start_code <- Sys.time()
# Preface -----------------------------------------------------------------

# Script to replicate analysis.

is.windows <- grepl('Windows', sessionInfo()$running)
if(!is.windows){
  stop('This replication package has been written for a Windows environment and will require additional 
       changes to be run under a different OS.')
}

# Make sure locale is correct
# R supports UTF-8 locale for versions 4.2.0 onwards
if((R.version$year >= 2023 | (R.version$year == 2022 & R.version$month>=3))){
  Sys.setlocale(category = 'LC_ALL', locale = 'en_GB.UTF-8')
}else{
  Sys.setlocale(category = "LC_ALL", locale = "English_United Kingdom.1252")
}

if (!require('renv')){
  install.packages('renv')
}

load <- base::load
# renv::activate()
# renv::restore()


# Function to source scripts with common defaults
source_script <- function(x){
  strt <- Sys.time()
  source(file.path("Scripts", x), echo = T, verbose = T, max.deparse.length = Inf, encoding = "UTF-8")
  fnsh <- Sys.time()
  rntme <- fnsh-strt
  cat("Runtime:", rntme)
}

source_do <- function(x){
  strt <- Sys.time()
  stata(file.path("Scripts", x), stata.echo = T)
  fnsh <- Sys.time()
  rntme <- fnsh-strt
  cat("Runtime:", rntme)
}


# Define variables later used to set the width and height of a plot in inches
fig_width = 24
fig_height = 18

# Define character vector of variables names of the main outcome variables
outcomes = c(
  "wages", 
  "jobs", 
  "payout", 
  "reserves", 
  "prices", 
  "investment",
  "tax", 
  "other")


# Define character vector of variable labels of the main outcome variables
outcome_labels = c(
  "Wages/Salaries",
  "Employment",
  "Distributed Profits",
  "Reserves",
  "Prices",
  "Investment",
  "Tax Planning",
  "Other"
)

ctrls <- "sector + legal + size_rev + impact_on_net_income"


# Load Libraries ----------------------------------------------------------

# Relevant libraries for analysis loaded
library(arrow)
library(tidyverse)
library(kableExtra)
library(fastDummies)
library(DescTools)
library(modelsummary)
library(haven)
library(tinytable)
library(fixest)
library(broom)
library(marginaleffects)
library(correlation)
library(ggridges)
library(car)
library(gt)
library(ggrepel)
library(bit64) # For adjusting int64 data type for stata
library(data.table)
library(magrittr)
library(fastDummies)
library(PracTools)
library(Rcpp)
library(writexl)
library(readxl)
library(furrr)
library(sf)
library(tidygeocoder)
library(purrr)
library(lmtest)
library(sandwich)
library(estimatr)

options("modelsummary_stars_note"=F)


if (!require(fmlogit)){
  devtools::install_github("f1kidd/fmlogit")
  library(fmlogit)
}

library(RStata)

options("RStata.StataPath" = "\"C:\\Program Files\\Stata17\\StataMP-64\"")
options("RStata.StataVersion" = 17)

# Prepare Orbis Flat Files ------------------------------------------------

## Financials ----
source_script("01_Orbis_Financials.R")

## Address Data ----
source_script("02_Orbis_Addresses.R")


# Prepare Survey Data -----------------------------------------------------

source_script("03_Survey_Data_Prep.R")

# Create Survey Weights ---------------------------------------------------

## Prepare data for raking ----

source_do("04_Preparation.do")

## Raking algorithm ----
source_do("05_Raking.do")

## Weight trimming ----
source_script("06_Trimming.R")

## Add weights to survey data
source_do("07_Merge_Survey_Weights.do")


# Descriptive Statistics --------------------------------------------------

source_script("08_Descriptives.R")


# Main Analysis -----------------------------------------------------------

source_script("09_Main_Analysis.R")


# Robustness --------------------------------------------------------------

source_do("10_Robustness_fmlogit.do")


# Prepare Data for Validation Checks --------------------------------------

## LBT Levy Rates ----
source_script("11_Levy_Rates.R")

## Municipality Links ----
source_script("12_Municipality_Links.R")

## Municipal Level Data ----
source_script("13_Municipal_Level_Data.R")

## Geocode Address Data ----
source_script("14_Geocode_Address_Data.R")

## Merge Data ----
source_script("15_Merge_Data.R")


# Validation Checks -------------------------------------------------------

## LBT Changes ----
source_script("16_Firm-level_Associations.R")

## COVID Proxies ----
source_script("17_Proxy_Test_Covid.R")


# Sample Comparison -------------------------------------------------------

## Orbis ----
source_do("18_comparison_Sample_Orbis.do")

## German Firm Population ----
source_do("19_comparison_Sample_PopulationGermany.do")



# Paper Tables and Figures ------------------------------------------------

source_script("20_Collect_Figs_Tabs.R")

# Total Runtime
end_code <- Sys.time()
print("Total Runtime:")
end_code-start_code