********************************************************************************
************** Preparation Incidence Tax for Weighting ****************
********************************************************************************

*************** Create missings for imputation *********************************
** (ccgic1-Rechtsform) 
** (ccgic3-Umsatz kategorisch) 
** (ccgic6-Mitarbeiter kategorisch)
** (industry_WZ08; 1-Steller)
/*
!!!!!
Keep identifier for later merge with raw data and weights
!!!!!
*/
********************************************************************************

set more off 
macro drop _all

***************
** Define paths
***************

global codepath ".\Scripts"
global datapath ".\Data"
global OUT ".\Data"
global surveypath ".\Data"

***************
** Read in data
***************
use "$surveypath\survey_data_prepped.dta", clear 




********************************************************************************
** Preparation Data
********************************************************************************

********************************************************************************
*** ID-Check (generate ID)
gen firm_id = _n
save "$surveypath\survey_data_prepped_withID.dta", replace



********************************************************************************
*** Revenues (compare to Codebook of Wave 2)
gen ccgic3 = rev_cat // no missings
 

********************************************************************************
*** Employess (compare to Codebook of Wave 2)
gen ccgic6 = num_emp_cat  // no missings


********************************************************************************
*** Industry (compare to Klassifikation der Wirtschaftszweige, Ausgabe 2008 (WZ 2008))
gen industry_WZ08_1 = industry_WZ08_1_letter



*** Drop industries for which marginal distribution is not available (Otherwise weights are overestimated) (See WZ08-Klassifikation)
replace industry_WZ08_1 = . if industry_WZ08_1== 1 // "A - Land- und Forstwirtschaft, Fischerei"
replace industry_WZ08_1 = . if industry_WZ08_1== 15 // "O - Sozialversicherung" / "Öffentliche Verwaltung, Verteidigung"
replace industry_WZ08_1 = . if industry_WZ08_1== 20 // "T - Herstellung von Waren und Erbringung von Dienstleistungen durch private Haushalte für den Eigenbedarf ohne ausgeprägten Schwerpunkt" / "Private Haushalte mit Hauspersonal"
replace industry_WZ08_1 = . if industry_WZ08_1== 21 //  "U - Exterritoriale Organisationen und Körperschaften"



********************************************************************************
************* Prepare  Dataset for imputation
keep firm_id ccgic3 rev_cat ccgic6 num_emp_cat industry_WZ08_1 industry_WZ08_1_letter
sort firm_id
order firm_id ccgic3 rev_cat ccgic6 num_emp_cat industry_WZ08_1 industry_WZ08_1_letter


export excel using "$datapath/TC_prepped_01_web.xlsx", replace firstrow(variables) sheet("TC_prepped_web")