********************************************************************************
**************** Sampling Weights Generation ****************
********************************************************************************

***********************************
*Install the necessary program (if not already done) 

*ssc install ipfraking
************************************

******************
* Define paths
******************

global codepath "./Scripts"
global datapath "./Data"
global OUT "./Data"



******************
* Read in the data
******************
import excel using "$datapath/TC_prepped_01_web.xlsx", clear firstrow




***** Count total observations
egen total=count(firm_id)



***********************************************************
**************** Econonomic Sectors ***********************



/*
*** Overview Economic sectors (see 01_preparation_uzBonn.do)
2 if industry_WZ08_1_letter== "B" //"Bergbau und Gewinnung von Steinen und Erden"
3 if industry_WZ08_1_letter== "C" // "Verarbeitendes Gewerbe"
4 if industry_WZ08_1_letter== "D" // "Energieversorgung"
5 if industry_WZ08_1_letter== "E" //"Abwasser- und Abfallentsorgung und Beseitigung von Umweltverschmutzungen" "Wasserversorgung"
6 if industry_WZ08_1_letter=="F" //"Baugewerbe" 
7 if industry_WZ08_1_letter=="G" // "Handel" "Instandhaltung und Reparatur von Kraftfahrzeugen"
8 if industry_WZ08_1_letter=="H" //"Verkehr und Lagerei"
9 if industry_WZ08_1_letter=="I" // "Gastgewerbe"
10 if industry_WZ08_1_letter=="J" //"Information und Kommunikation"
11 if industry_WZ08_1_letter=="K" //"Erbringung von Finanz- und Versicherungsdienstleistungen"
12 if industry_WZ08_1_letter=="L" //"Grundstücks- und Wohnungswesen"
13 if industry_WZ08_1_letter=="M" //"Erbringung von freiberuflichen, wissenschaftlichen und technischen Dienstleistungen"
14 if industry_WZ08_1_letter=="N" // "Erbringung von sonstigen wirtschaftlichen Dienstleistungen"
16 if industry_WZ08_1_letter=="P" //"Erziehung und Unterricht"
17 if industry_WZ08_1_letter=="Q" //"Gesundheits- und Sozialwesen"
18 if industry_WZ08_1_letter=="R" //"Kunst, Unterhaltung und Erholung"
19 if industry_WZ08_1_letter=="S" // "Erbringung von sonstigen Dienstleistungen"
*/








********************************************************************************
********************************************************************************

/*
** Population Margins Wirtschaftszweige 
(see Excel-File: "Destatis_Randverteilungen 2019" in A:\Data\GermanBusinessPanelTeam\Winter\TaxIncidenceReplPackage\TaxIncidence\weights)
*/


*This will be used as a starting point for the weights 
gen pop_industry=.
replace pop_industry=.000568668 if industry_WZ08_1_letter== "B"
replace pop_industry=.064262529 if industry_WZ08_1_letter== "C"
replace pop_industry=.022440736 if industry_WZ08_1_letter== "D"
replace pop_industry=.003252981 if industry_WZ08_1_letter== "E"
replace pop_industry=.109952981 if industry_WZ08_1_letter== "F"
replace pop_industry=.171213057 if industry_WZ08_1_letter== "G"
replace pop_industry=.032282001 if industry_WZ08_1_letter== "H"
replace pop_industry=.071435214 if industry_WZ08_1_letter== "I"
replace pop_industry=.038633433 if industry_WZ08_1_letter== "J"
replace pop_industry=.021298343 if industry_WZ08_1_letter== "K"
replace pop_industry=.053147381 if industry_WZ08_1_letter== "L"
replace pop_industry=.149879313 if industry_WZ08_1_letter== "M"
replace pop_industry=.064458921 if industry_WZ08_1_letter== "N"
replace pop_industry=.02263741  if industry_WZ08_1_letter== "P"
replace pop_industry=.071339125 if industry_WZ08_1_letter== "Q"
replace pop_industry=.033955412 if industry_WZ08_1_letter== "R"
replace pop_industry=.069242585 if industry_WZ08_1_letter== "S"







*******************************************************************
********************** Revenues ***********************************

gen revenue_rake=. 
** 0 - 2 Millionen
replace revenue_rake=1 if ccgic3<=5
** 2 - 10 Millionen
replace revenue_rake=2 if ccgic3==6 | ccgic3==7 |ccgic3==8
** 10 - 50 Millionen
replace revenue_rake=3 if ccgic3==9 | ccgic3==10 | ccgic3==11 | ccgic3==12
** 50  Millionen und mehr
replace revenue_rake=4 if ccgic3==13 | ccgic3==14 






*********************************************************************
************************ Employees **********************************

gen employees_rake=. 
** 0 - 9 Mitarbeiter
replace employees_rake=1 if ccgic6<=3 
** 10 -49 Mitarbeiter
replace employees_rake=2 if ccgic6==4 |ccgic6==5 
** 50 - 249 Mitarbeiter
replace employees_rake=3 if ccgic6==6 
** 250 - mehr Mitarbeiter
replace employees_rake=4 if ccgic6==7 | ccgic6==8 | ccgic6==9





********************************************************************
********************** Variable Labels *****************************

label define _employees_raked 1 "0 bis 9" 2 "10 bis 49" 3 "50 bis 249" 4 "250 und mehr" 
label values employees_rake _employees_raked

label define _revenue_raked 1 "unter 2 Mio." 2 "2 Mio. bis 10 Mio." 3 "10 Mio. bis 50 Mio." 4 ">50 Mio."
label values revenue_rake _revenue_raked

label define _sector_raked 2 "B - Bergbau und Gewinnung von Steinen und Erden" 3 "C - Verarbeitendes Gewerbe" 4 "D - Energieversorgung" 5 "E - Abwasser- und Abfallentsorgung/Wasserversorgung" 6 "F - Baugewerbe" 7 "G - Handel/Instandhaltung und Reparatur von Kraftfahrzeugen" 8 "H - Verkehr und Lagerei" 9 "I - Gastgewerbe" 10 "J - Information und Kommunikation" 11 "K - Erbringung von Finanz- und Versicherungsdienstleistungen" 12 "L - Grundstücks- und Wohnungswesen" 13 "M - Erbringung von freiberuflichen, wissenschaftlichen und technischen Dienstleistungen" 14 "N - Erbringung von sonstigen wirtschaftlichen Dienstleistungen" 16 "P - Erziehung und Unterricht" 17 "Q - Gesundheits- und Sozialwesen" 18 "R - Kunst, Unterhaltung und Erholung" 19 "S - Erbringung von sonstigen Dienstleistungen"
label values industry_WZ08_1 _sector_raked


label variable employees_rake "Mitarbeiter*innen" 
label variable revenue_rake "Umsatz" 
label variable industry_WZ08_1 "Wirtschaftssektor (1-Steller)"




********************************************************************************
**************** Generate weights for algorithm starting value *****************

** As starting weights we use the industry distribution in Germany


** generate frequencies for variables in dataset
count if !missing(industry_WZ08_1)
bysort industry_WZ08_1: gen industry_WZ08_1_freq = _N / `r(N)' if !missing(industry_WZ08_1)


** generate sample weights according to destatis distribution
gen weight_industry=. 
replace weight_industry=pop_industry/industry_WZ08_1_freq




*******************************************************************
****************** Implement raking method ************************
*******************************************************************
	 
/*
** Population Numbers from:
(see Excel-File: "Destatis_Randverteilungen 2019" in A:\Data\GermanBusinessPanelTeam\Winter\TaxIncidenceReplPackage\TaxIncidence\weights)
*/	 
	 
	  
version 15
		 
* setting up the totals
generate byte _one = 1
         
matrix total_industry = (2024, 228723, 79871, 11578, 391344, 609381, 114898, 254252, 137504, 75805, 189162, 533450, 229422, 80571, 253910, 120854, 246448) 
matrix colnames total_industry= 2 3 4 5 6 7 8 9 10 11 12 13 14 16 17 18 19	 
matrix rownames total_industry= industry_WZ08_1
matrix coleq total_industry = _one
			  
matrix total_employees= (3110639, 357937, 73823, 16798) 
matrix colnames total_employees= 1 2 3 4 
matrix rownames total_employees = employees_rake
matrix coleq total_employees = _one

matrix total_revenue= (3316554, 180383, 47629, 14631) 
matrix colnames total_revenue= 1 2 3 4 
matrix rownames total_revenue= revenue_rake
matrix coleq total_revenue = _one	  

	 

*********************************************************	
****************** Raking *******************************


* Drop missing values in legalform >> Should be nothing due to imputations
drop if employees_rake==. 
drop if revenue_rake==.
drop if industry_WZ08_1==.


ipfraking [pw=weight_industry], generate(rakedwgt_web) ctotal(total_industry total_employees total_revenue) iterate(1000)




****************
* Save dataset
****************

keep  firm_id rakedwgt_web
order firm_id rakedwgt_web


save "$OUT/survey_weights_TI_before_trimm_02_web.dta", replace


graph close all



