################################################################################
################# Trimming Weights #######################
################################################################################


# Read in data ------------------------------------------------------------
dat <- read_dta('./Data/survey_weights_TI_before_trimm_02_web.dta')



# Summary Statistics ------------------------------------------------------
summary(dat$rakedwgt_web)
var(dat$rakedwgt_web)
sum(dat$rakedwgt_web)



# Trimming Function -------------------------------------------------------
trunc.bounds<-function(di,bound){
  n<-sum(di)
  nopt<-di
  i<-0
  s<-which(di<=0|di<bound[1]|di>bound[2])
  while(i<n){
    if(length(s)!=0){
      s1<-which(nopt<=0)
      s2<-which(nopt<bound[1])
      s3<-which(nopt>bound[2])
      nopt[s1]<-bound[1]
      nopt[s2]<-bound[1]
      nopt[s3]<-bound[2]
      su<-length(s1)*bound[1]+length(s2)*bound[1]+length(s3)*bound[2]
      ge<-(n-su)*nopt[-s]/sum(nopt[-s])
      nopt[-s]<-ge
      s<-which(nopt<=0|nopt<bound[1]|nopt>bound[2])}
    if(length(s)!=0){
      i<- i+1
      fi<-i}
    else {
      fi<-i+1
      i<-n
    }
  }
  cat(" N of iterations: ",fi,"\n",
      "Number of trimmed weights: ",length(which(nopt%in%bound)),"\n",
      "Minimum value:",sum(di^2/nopt))
  return(nopt)
}



# Create data frame -------------------------------------------------------
dat <- as.data.frame(dat)



# Trimm weights  ----------------------------------------------------------
dat$survey_weights_web <- trunc.bounds(dat$rakedwgt_web, c(quantile(dat$rakedwgt_web,probs = 
                                                                    c(0.05,0.95))))




#  Trim check -------------------------------------------------------------
summary(dat$survey_weights_web)
var(dat$survey_weights_web)
sum(dat$survey_weights_web)
deff_sw<-deff(w=dat$survey_weights_web, type="kish")
deff_sw



# Save data ---------------------------------------------------------------
write_dta(dat, "Data/survey_weights_final_03_web.dta")
rm(dat, deff_sw)
gc()