

*******************
* Define globals
*******************

global codepath "./Scripts"
global datapath "./Data"
global OUT "./Data"
global surveypath "./Data"



*************************************************************
** Merge the weights with the final data set and save this
*************************************************************

use "${OUT}\survey_weights_final_03_web.dta", clear
sort firm_id


** drop unnecessary weights
drop rakedwgt_web


** relabel survey weights
rename survey_weights_web weight_web
label variable weight_web "survey weight - web"


merge 1:1 firm_id using "${surveypath}/survey_data_prepped_withID.dta"
drop _merge



*** Prepare final survey
order weight_web, last
sort firm_id
drop firm_id


***
keep if weight_web != .

save "${surveypath}/survey_data_prepped_with_weights.dta", replace



********************************************************************************

