**# Preface 

set more off 
macro drop _all

**# Set Paths

pwd

global datapath ".\Data"
global tablepath ".\Tables"

**# Set Outcomes

global outcomes wages jobs payout reserves prices investment tax other


**# Load and Prep Data

use ${datapath}/survey_data_prepped_with_weights, clear

encode treat_sign, gen(treat_sign_enc)

* Install if necessary

ssc install fmlogit 


**# Run regression

fmlogit ${outcomes}, etavar(i.treat_sign_enc##i.treat_mag i.sector i.legal i.size_rev i.respondent i.impact_on_revenue i.impact_on_net_income)

**# Compute marginal effects and save them to file

foreach i in $outcomes {
	display "`i'"
	qui margins, dydx(treat_sign_enc treat_mag) predict(outcome(`i')) saving(${datapath}/margins_`i', replace)
	preserve
	use ${datapath}/margins_`i', clear
	gen outcome = "`i'"
	save ${datapath}/margins_`i', replace
	restore
}

**# Combine Marginal Effects

use ${datapath}/margins_wages, clear

local vars $outcomes
di "`vars'"
local omit wages

local vars: list vars - omit
di "`vars'"

foreach i in `vars' {
	append using ${datapath}/margins_`i', nolabel nonotes
}

**# Clean data and save to file

rename _deriv variable
rename _margin marginal_effect
rename _se_margin std_dev
rename _statistic t_stat
rename _pvalue p_value
rename _ci_lb conf_lower
rename _ci_ub conf_upper

* Only keep variables of interest
keep outcome variable marginal_effect std_dev t_stat p_value conf_lower conf_upper

* Give variables more descriptive labels
label define vars 1 "treat_signIncrease" 2 "treat_magMedium" 3 "treat_magLarge"
label values variable vars

* Save data to csv file
export delimited using ${tablepath}/marginal_effects_fmlogit, replace

