
# Load data ---------------------------------------------------------------

levy_data = read_parquet(file = "Data/levy_data.parquet")

ags_data = read_parquet(file = "Data/ags_zip_code.parquet")

muni_panel = ags_data |> 
  mutate(district = str_sub(ags, 1, 5)) |> 
  inner_join(levy_data, by = c("ags", "year", "state"))

muni_panel <- muni_panel |> 
  select(ags, year, zip_code, levy_lbt)

muni_panel |> 
  group_by(ags) |> 
  arrange(year, .by_group = TRUE) |> 
  mutate(n_years = n(),
         levy_lbt = levy_lbt / 100,
         lbt_change = levy_lbt - lag(levy_lbt),
         lbt_change_sign = case_when(
           lbt_change > 0 ~ "Increase",
           lbt_change < 0 ~ "Decrease",
           .default = "No change"
         )) -> muni_panel

write_parquet(muni_panel, sink = "Data/municipality_panel.parquet")

rm(levy_data, ags_data, muni_panel)
gc()