********************************************************************************
************** Comaprison: Survey Sample vs. Orbis *****************************

clear all
set more off
********************************************************************************


global path_data ".\Data"
global path_tables ".\Tables"


********************************************************************************


********************************************************************************
******************  Respondents vs. Non-respondents ****************************
********************************************************************************

use "${path_data}\final_iab_panel_2019.dta", clear



** Check 1 
summarize total_assets num_emp_financials turnover costs_of_employees taxation

** We only consider firms with non-negative entry in total assets
replace total_assets = . if total_assets < 0

** We only consider firms with non-negative entry in employees
replace num_emp_financials = . if num_emp_financials < 0

** We only consider firms with non-negative entry in turnover
replace turnover = . if turnover < 0

** We only consider firms with non-negative entry in costs_of_employees
replace costs_of_employees = . if costs_of_employees < 0

** We only consider firms with non-negative entry in costs_of_employees
replace taxation = . if taxation < 0


** Check 2
summarize total_assets num_emp_financials turnover costs_of_employees taxation

** Check 3: 
/*
Additionally, firms in the linking group and with information on employees in Orbis 
reported a lower number of employees in the survey itself (Mean: 43, Median: 6), 
reinforcing the reliability of our survey responses.
*/
sum num_emp_survey if participant == 1 & num_emp_financials != ., d


eststo clear

** Descrpitives & t-Test

eststo participant: estpost summarize total_assets num_emp_financials turnover costs_of_employees taxation if participant==1, d
eststo non_participant: estpost summarize total_assets num_emp_financials turnover costs_of_employees taxation if participant==0, d

esttab participant non_participant, cell("count mean (fmt(2)) p50 (fmt(2))") mtitle("Respondents" "Non-Respondents") nogaps compress replace
esttab participant non_participant using "${path_tables}\descriptives_sample_orbis_comp.tex", cell("count mean (fmt(2)) p50 (fmt(2))") mtitle("Respondents" "Non-Respondents") nogaps compress replace


local p_count_assets = r(coefs)[1,1]
local p_mean_assets = r(coefs)[1,2]
local p_p50_assets = r(coefs)[1,3]
local np_count_assets = r(coefs)[1,4]
local np_mean_assets = r(coefs)[1,5]
local np_p50_assets = r(coefs)[1,6]

local p_count_emp = r(coefs)[2,1]
local p_mean_emp = r(coefs)[2,2]
local p_p50_emp = r(coefs)[2,3]
local np_count_emp = r(coefs)[2,4]
local np_mean_emp = r(coefs)[2,5]
local np_p50_emp = r(coefs)[2,6]


local p_count_turno = r(coefs)[3,1]
local p_mean_turno = r(coefs)[3,2]
local p_p50_turno = r(coefs)[3,3]
local np_count_turno = r(coefs)[3,4]
local np_mean_turno = r(coefs)[3,5]
local np_p50_turno = r(coefs)[3,6]


local p_count_ce = r(coefs)[4,1]
local p_mean_ce = r(coefs)[4,2]
local p_p50_ce = r(coefs)[4,3]
local np_count_ce = r(coefs)[4,4]
local np_mean_ce = r(coefs)[4,5]
local np_p50_ce = r(coefs)[4,6]


local p_count_tax = r(coefs)[5,1]
local p_mean_tax = r(coefs)[5,2]
local p_p50_tax = r(coefs)[5,3]
local np_count_tax = r(coefs)[5,4]
local np_mean_tax = r(coefs)[5,5]
local np_p50_tax = r(coefs)[5,6]



local p_n = r(stats)[1,1]
local np_n = r(stats)[1,2]


** T-tests
eststo difftest: estpost ttest total_assets num_emp_financials turnover costs_of_employees taxation, by(participant)

esttab difftest, replace mtitle("Mean Difference") b(2) p(2)
esttab difftest using "${path_tables}\ttests_sample_orbis_final.tex", replace mtitle("Mean Difference") b(2) p(2)

local p_val_assets = r(coefs)[1,2]
local p_val_emp = r(coefs)[2,2]
local p_val_turno = r(coefs)[3,2]
local p_val_ce = r(coefs)[4,2]
local p_val_tax = r(coefs)[5,2]



matrix T = [ ///
`p_count_assets', `p_mean_assets' , `p_p50_assets', `np_count_assets', `np_mean_assets' , `np_p50_assets', `p_val_assets' \ ///
`p_count_emp', `p_mean_emp' , `p_p50_emp', `np_count_emp', `np_mean_emp' , `np_p50_emp', `p_val_emp'  \ ///
`p_count_turno', `p_mean_turno' , `p_p50_turno', `np_count_turno', `np_mean_turno' , `np_p50_turno',  `p_val_turno' \ ///
`p_count_ce', `p_mean_ce' , `p_p50_ce', `np_count_ce', `np_mean_ce' , `np_p50_ce',  `p_val_ce' \  ///
`p_count_tax', `p_mean_tax' , `p_p50_tax', `np_count_tax', `np_mean_tax' , `np_p50_tax',  `p_val_tax'   ///
]


matrix list T

matrix TN=[`p_n', . , .  , `np_n', . , ., . ]


*** Build table
frmttable, statmat(T) sdec(2) ///
ctitles("", "Participants", "",  "",  "Non-Participants", "",  "", "" \ ///
"", "Obs.", "Mean",  "p50",  "Obs.", "Mean",  "p50", "p-value") ///
rtitles("Total Assets" \ "Number of Employees" \ "Turnover" \ "Costs of Employees" \ "Tax Liability") 

*frmttable, statmat(TN) sdec(0) rtitle("\(N\)") append 


frmttable using "${path_tables}\comparison_sample_orbis_fy2019", replace tex nocenter plain



********************************************************************************
****************** Linking vs. Non-Linking Agreement ***************************
********************************************************************************

use "${path_data}\survey_data_prepped_with_weights.dta", clear



** Check 
summarize rev num_emp legal_Corporation legal_SoleProprietor legal_Partnership sector_Other sector_Manufacturing sector_Construction sector_Trade


gen link = .
replace link = 1 if cdat3 ==1
replace link = 0 if cdat3 !=1



eststo clear

** Descrpitives & t-Test

eststo link: estpost summarize rev num_emp legal_Corporation legal_SoleProprietor legal_Partnership sector_Manufacturing sector_Construction sector_Trade sector_Other if link==1, d
eststo no_link: estpost summarize rev num_emp legal_Corporation legal_SoleProprietor legal_Partnership sector_Manufacturing sector_Construction sector_Trade sector_Other if link==0, d

*esttab link no_link, cell("count mean (fmt(2)) p50 (fmt(2))") mtitle("Linking Agreed" "Linking Not Agreed") nogaps compress replace
esttab link no_link using "${path_tables}\descriptives_link_nolink.tex", cell("count mean (fmt(2)) p50 (fmt(2))") mtitle("Linking Agreed" "Linking Not Agreed") nogaps compress replace


local p_count_rev = r(coefs)[1,1]
local p_mean_rev = r(coefs)[1,2]
local p_p50_rev = r(coefs)[1,3]
local np_count_rev = r(coefs)[1,4]
local np_mean_rev = r(coefs)[1,5]
local np_p50_rev = r(coefs)[1,6]

local p_count_emp = r(coefs)[2,1]
local p_mean_emp = r(coefs)[2,2]
local p_p50_emp = r(coefs)[2,3]
local np_count_emp = r(coefs)[2,4]
local np_mean_emp = r(coefs)[2,5]
local np_p50_emp = r(coefs)[2,6]


local p_count_corp = r(coefs)[3,1]
local p_mean_corp = r(coefs)[3,2]
local p_p50_corp = r(coefs)[3,3]
local np_count_corp = r(coefs)[3,4]
local np_mean_corp = r(coefs)[3,5]
local np_p50_corp = r(coefs)[3,6]


local p_count_sp = r(coefs)[4,1]
local p_mean_sp = r(coefs)[4,2]
local p_p50_sp = r(coefs)[4,3]
local np_count_sp = r(coefs)[4,4]
local np_mean_sp = r(coefs)[4,5]
local np_p50_sp = r(coefs)[4,6]


local p_count_partner = r(coefs)[5,1]
local p_mean_partner = r(coefs)[5,2]
local p_p50_partner = r(coefs)[5,3]
local np_count_partner = r(coefs)[5,4]
local np_mean_partner = r(coefs)[5,5]
local np_p50_partner = r(coefs)[5,6]


local p_count_manf = r(coefs)[6,1]
local p_mean_manf = r(coefs)[6,2]
local p_p50_manf = r(coefs)[6,3]
local np_count_manf = r(coefs)[6,4]
local np_mean_manf = r(coefs)[6,5]
local np_p50_manf = r(coefs)[6,6]


local p_count_constr = r(coefs)[7,1]
local p_mean_constr = r(coefs)[7,2]
local p_p50_constr = r(coefs)[7,3]
local np_count_constr = r(coefs)[7,4]
local np_mean_constr = r(coefs)[7,5]
local np_p50_constr = r(coefs)[7,6]



local p_count_trade = r(coefs)[8,1]
local p_mean_trade = r(coefs)[8,2]
local p_p50_trade = r(coefs)[8,3]
local np_count_trade = r(coefs)[8,4]
local np_mean_trade = r(coefs)[8,5]
local np_p50_trade = r(coefs)[8,6]



local p_count_other = r(coefs)[9,1]
local p_mean_other = r(coefs)[9,2]
local p_p50_other = r(coefs)[9,3]
local np_count_other = r(coefs)[9,4]
local np_mean_other = r(coefs)[9,5]
local np_p50_other = r(coefs)[9,6]



local link_n = r(stats)[1,1]
local nolink_n = r(stats)[1,2]


** T-tests
eststo difftest: estpost ttest rev num_emp legal_Corporation legal_SoleProprietor legal_Partnership sector_Manufacturing sector_Construction sector_Trade sector_Other, by(link)

*esttab difftest, replace mtitle("Mean Difference") b(2) p(2)
esttab difftest using "${path_tables}\ttests_link_nolink.tex", replace mtitle("Mean Difference") b(2) p(2)

local p_val_rev = r(coefs)[1,2]
local p_val_emp = r(coefs)[2,2]
local p_val_corp = r(coefs)[3,2]
local p_val_sp = r(coefs)[4,2]
local p_val_partner = r(coefs)[5,2]
local p_val_manf = r(coefs)[6,2]
local p_val_constr = r(coefs)[7,2]
local p_val_trade = r(coefs)[8,2]
local p_val_other = r(coefs)[9,2]


matrix T = [ ///
`p_count_rev', `p_mean_rev' , `p_p50_rev', `np_count_rev', `np_mean_rev' , `np_p50_rev', `p_val_rev' \ ///
`p_count_emp', `p_mean_emp' , `p_p50_emp', `np_count_emp', `np_mean_emp' , `np_p50_emp', `p_val_emp' \ ///
`p_count_corp', `p_mean_corp' , `p_p50_corp', `np_count_corp', `np_mean_corp' , `np_p50_corp', `p_val_corp' \ ///
`p_count_sp', `p_mean_sp' , `p_p50_sp', `np_count_sp', `np_mean_sp' , `np_p50_sp', `p_val_sp' \ ///
`p_count_partner', `p_mean_partner' , `p_p50_partner', `np_count_partner', `np_mean_partner' , `np_p50_partner', `p_val_partner' \ ///
`p_count_manf', `p_mean_manf' , `p_p50_manf', `np_count_manf', `np_mean_manf' , `np_p50_manf', `p_val_manf' \ ///
`p_count_constr', `p_mean_constr' , `p_p50_constr', `np_count_constr', `np_mean_constr' , `np_p50_constr', `p_val_constr' \ ///
`p_count_trade', `p_mean_trade' , `p_p50_trade', `np_count_trade', `np_mean_trade' , `np_p50_trade', `p_val_trade' \ ///
`p_count_other', `p_mean_other' , `p_p50_other', `np_count_other', `np_mean_other' , `np_p50_other', `p_val_other'   ///
]

matrix list T




matrix TN=[`link_n', . , .  , `nolink_n', . , ., . ]


*** Build table
frmttable, statmat(T) sdec(2) ///
ctitles("", "Linking Agreed", "",  "",  "Linking Not Agreed", "",  "", "" \ ///
"", "Obs.", "Mean",  "p50",  "Obs.", "Mean",  "p50", "p-value") ///
rtitles("Revenues" \ "Number of Employees" \ "Corporation" \ "Sole Proprietor" \ "Partnership" \ "Manufacturing" \ "Construction" \ "Trade" \ "Other Sector" ) 

frmttable, statmat(TN) sdec(0) rtitle("\(N\)") append 


frmttable using "${path_tables}\comparison_link_nolink", replace tex nocenter plain












